#!/bin/bash
# Theresa L. Ford, 12/2009, www.cattail.nu
# Version 3.0
# Uses configuration Version 1.1

# This is a wrapper that sends the username, password, and png to the sendtosolona utility.

# This script looks in the defined directory for the latest png file, sends the file to solona.net,
# and then will archive, delete, or do nothing to the png file.


##################################################################################
# Do not edit below this line unless you know what you are doing.

myscriptpath=`echo $0 | rev | awk '{firstslash=index($0,"/");print substr($0,firstslash+1,length($0)); }' | rev`
mynameofscript=`echo $0 | rev | awk -F \/ '{print $1}'|rev`

. $myscriptpath/configuration

myerrorfile=$myscriptpath"/"$mynameofscript"_errors"
mypngsfile=$myscriptpath"/"$mynameofscript"_pngs"
mypngfile=$myscriptpath"/"$mynameofscript"_png"

# remove the old error file if there was one, don't care if it wasn't found
rm $myerrorfile 2>/dev/null

# list pngs, if no files, the error is going to the error file
# the -t sorts by file modified date, so the last one done will be at the top
mycmd="ls -t "$mypicturedirectory"*.png"

#echo $mypngfile

$mycmd 2>$myerrorfile > $mypngfile

# check for the error file
if [ -s $myerrorfile ] ; then
  echo "No png file found in the specified directory. Exact error:"
  cat $myerrorfile
  # remove the old error file if there was one, don't care if it wasn't found
  rm $myerrorfile 2> /dev/null
  exit 1
fi

# get the latest file, and escape the spaces
head -1 $mypngfile > $mypngsfile
rm $mypngfile

cat $mypngsfile | sed "1,$ s/\ /\\\ /g" > $mypngfile
rm $mypngsfile

mypngsfile=`cat $mypngfile`

mypngfile=$mypngsfile

if [ $myverificationprompt -eq 1 ]; then
  echo "About to send $mypngfile . Is this OK? y n"
  read choice
  case $choice in
    y|Y|yes|Yes|YES)
    ;;
    *)
    echo "File not sent.  Exiting."
    exit 1
    ;;
  esac
fi

myarguments=" "$mylogin" "$mypassword" "$mypngfile""
mycommand=" "$myscriptpath/sendtosolona" "$myarguments"" 

echo $mycommand
$mycommand

